﻿using System.Linq;
using System.Reflection;
using HugsLib;
using HugsLib.Settings;
using RimWorld;
using Verse;

namespace AlcoholV
{
    internal class ACSmartSpeed : ModBase
    {
        private static Assembly Assembly => Assembly.GetAssembly(typeof (ACSmartSpeed));
        private static string AssemblyName => Assembly.FullName.Split(',').First();
        public override string ModIdentifier => AssemblyName;

        public static SettingHandle<Option> CurrSetting { get; private set; }

        public override void Initalize()
        {
            InitUltraFastMode();
            InitEventSpeedControl();
        }

        public override void DefsLoaded()
        {
            LongEventHandler.ExecuteWhenFinished(PrepareSettingsHandles);
        }

        private void PrepareSettingsHandles()
        {
            CurrSetting = Settings.GetHandle("EventSpeed", "EventSpeed".Translate(), "SetEventSpeed".Translate(), Option.Normal, null, "ACSmartSpeed");
        }

        private void InitUltraFastMode()
        {
            var source = typeof (TimeControls).GetMethod("DoTimeControlsGUI", BindingFlags.Static | BindingFlags.Public);
            var dest = typeof (Detour.TimeControls).GetMethod("DoTimeControlsGUI", BindingFlags.Static | BindingFlags.Public);
            DetourProvider.CompatibleDetour(source, dest, ModIdentifier);
        }

        private void InitEventSpeedControl()
        {
            var source = typeof (TickManager).GetProperty("TickRateMultiplier", BindingFlags.Instance | BindingFlags.Public).GetGetMethod();
            var dest = typeof (Detour.TickManager).GetProperty("TickRateMultiplier", BindingFlags.Instance | BindingFlags.Public).GetGetMethod();
            DetourProvider.CompatibleDetour(source, dest, ModIdentifier);
        }

        internal enum Option
        {
            Slow,
            Normal,
            Fast,
            Half,
            Ignore
        }
    }
}